/*
 * Decompiled with CFR 0.152.
 */
package ags.ui.graphics;

import ags.ui.graphics.ColorYIQ;
import java.util.ArrayList;
import java.util.List;

public abstract class PaletteYIQ {
    List<ColorYIQ> colors = new ArrayList<ColorYIQ>();

    public PaletteYIQ() {
        this.initPalette();
    }

    protected abstract void initPalette();

    public ColorYIQ getColor(int col) {
        return this.colors.get(col);
    }

    public void addColor(ColorYIQ col) {
        this.colors.add(col);
    }

    public void addColor(double y, double i, double q) {
        ColorYIQ col = new ColorYIQ(y, i, q);
        this.addColor(col);
    }

    public int findColor(ColorYIQ search) {
        double lastDist = 0.0;
        ColorYIQ bestFit = this.colors.get(0);
        for (ColorYIQ test : this.colors) {
            double dist = Math.abs(test.distance(search));
            if (!(dist > lastDist)) continue;
            lastDist = dist;
            bestFit = test;
        }
        return this.colors.indexOf(bestFit);
    }
}

